% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lst.R
\name{nmlst}
\alias{nmlst}
\title{Reads the NONMEM \code{.lst} file for final parameter information}
\usage{
nmlst(file, strictLst = FALSE)
}
\arguments{
\item{file}{File where the list is located}

\item{strictLst}{The list parsing needs to be correct for a
successful load (default \code{FALSE}).}
}
\value{
return a list with \verb{$theta}, \verb{$eta} and \verb{$eps} and other
information about the control stream
}
\description{
Reads the NONMEM \code{.lst} file for final parameter information
}
\examples{
nmlst(system.file("mods/DDMODEL00000322/HCQ1CMT.lst", package="nonmem2rx"))
nmlst(system.file("mods/DDMODEL00000302/run1.lst", package="nonmem2rx"))
nmlst(system.file("mods/DDMODEL00000301/run3.lst", package="nonmem2rx"))
nmlst(system.file("mods/cpt/runODE032.res", package="nonmem2rx"))
}
\author{
Matthew L. Fidler
}
