% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{metaplot.character}
\alias{metaplot.character}
\title{Metaplot Character, Nonstandard Evaluation}
\usage{
\method{metaplot}{character}(x, ..., groups, meta = match.fun("meta")(x),
  simplify = TRUE, sort = TRUE, subset)
}
\arguments{
\item{x}{object}

\item{...}{unquoted names of variables to plot, or other named arguments (passed)}

\item{groups}{columns by which to group the dataset, passed to fold_}

\item{meta}{pre-folded metadata; meta(x) by default}

\item{simplify}{whether to simplify the result, passed to fold_}

\item{sort}{whether to sort the result, passed to fold_}

\item{subset}{a condition for filtering data, passed to fold_}
}
\description{
Plots character by treating as model name.  A dataset
is constructed by combining the meta version of the model input with a
meta version of the model output and calling metaplot with the result.
}
\examples{
library(magrittr)
library(metaplot)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% metaplot(
 CWRESI, TAD, SEX, 
 groups = c('ID','TIME'), 
 subset = 'MDV == 0',
 yref=0, 
 alpha = 0.1, 
 ysmooth = TRUE
)
}
\seealso{
\code{fold}
}
