% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likebut.R
\name{estimates.character}
\alias{estimates.character}
\title{Get Estimates for Character}
\usage{
\method{estimates}{character}(x, xmlfile = modelpath(x, ext = "xml", ...),
  strip.namespace = TRUE, digits = 3, ...)
}
\arguments{
\item{x}{character (modelname)}

\item{xmlfile}{path to xml file}

\item{strip.namespace}{whether to strip e.g. nm: from xml elements for easier xpath syntax}

\item{digits}{passed to signif}

\item{...}{dots}
}
\value{
numeric
}
\description{
Gets model parameter estimates in canonical order, treating character as model names. 
See \code{\link{parameters}} for a less formal interface.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% estimates
}
\seealso{
nms_canonical errors
}
