% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getset.R
\name{fixed.model}
\alias{fixed.model}
\title{Check If Model is Fixed}
\usage{
\method{fixed}{model}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{dots}
}
\value{
logical
}
\description{
Checks if model is fixed.  Returns a logical vector with element for each init, in canonical order.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% as.model \%>\% fixed
}
\seealso{
Other fixed: 
\code{\link{fixed<-.inits}()},
\code{\link{fixed<-.init}()},
\code{\link{fixed<-.model}()},
\code{\link{fixed<-}()},
\code{\link{fixed}()}
}
\concept{fixed}
