% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{nms_pmx.nms_canonical}
\alias{nms_pmx.nms_canonical}
\title{Convert Canonical Names to pmxTools}
\usage{
\method{nms_pmx}{nms_canonical}(x, ...)
}
\arguments{
\item{x}{nms_canonical}

\item{...}{ignored}
}
\value{
nms_pmx (character)
}
\description{
Converts nms_canonical to nms_pmx.
I.e., theta_01 becomes THETA1, and 
omega_01_01 becomes OM1,1.
}
\examples{
library(magrittr)
c(
   'theta_15',
   'omega_01_01',
   'omega_01_02',
   'sigma_01_01',
   'sigma_02_01'
) \%>\%
as_nms_canonical \%>\%
nms_pmx

}
\seealso{
Other nms: 
\code{\link{as_nms_canonical}()},
\code{\link{as_nms_nonmem}()},
\code{\link{as_nms_pmx}()},
\code{\link{as_nms_psn}()},
\code{\link{nms_canonical.character}()},
\code{\link{nms_canonical.model}()},
\code{\link{nms_canonical.nms_nonmem}()},
\code{\link{nms_canonical.nms_pmx}()},
\code{\link{nms_canonical.numeric}()},
\code{\link{nms_canonical}()},
\code{\link{nms_nonmem.character}()},
\code{\link{nms_nonmem.model}()},
\code{\link{nms_nonmem.nms_canonical}()},
\code{\link{nms_nonmem.nms_pmx}()},
\code{\link{nms_nonmem.numeric}()},
\code{\link{nms_nonmem}()},
\code{\link{nms_pmx.nms_nonmem}()},
\code{\link{nms_pmx}()},
\code{\link{nms_psn.character}()},
\code{\link{nms_psn.model}()},
\code{\link{nms_psn.numeric}()},
\code{\link{nms_psn}()}
}
\concept{nms}
