% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{rosetta}
\alias{rosetta}
\alias{nms}
\title{Translate Parameter Names}
\description{
Translate among various idioms for expressing parameter names
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))

# we generate some nonmem parameter names in nonmem format
1001 \%>\% nms_nonmem -> nonmem
nonmem

# from these we generate canonical and pmxTools equivalents
canonical <- nms_canonical(nonmem)
pmxtools <- nms_pmx(nonmem)
canonical
pmxtools

# We demonstrate equivalence
stopifnot(identical(nonmem, nms_nonmem(canonical)))
stopifnot(identical(nonmem, nms_nonmem(pmxtools)))
stopifnot(identical(canonical, nms_canonical(nonmem)))
stopifnot(identical(canonical, nms_canonical(pmxtools)))
stopifnot(identical(pmxtools, nms_pmx(nonmem)))
stopifnot(identical(pmxtools, nms_pmx(canonical)))

# on-the-fly conversions
nonmem \%>\% class
nonmem \%>\% nms_pmx
nonmem \%>\% nms_canonical
nonmem \%>\% nms_canonical \%>\% nms_pmx
nonmem \%>\% nms_canonical \%>\% nms_pmx \%>\% nms_nonmem

# comparison
data.frame(
 can = I(canonical),
 non = I(nonmem),
 pmx = I(pmxtools),
 psn = I(nms_psn(1001))
)
}
