% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icci}
\alias{icci}
\title{Information Criteria Confidence Intervals}
\usage{
icci(object1, object2, conf.level = 0.95)
}
\arguments{
\item{object1}{a model object}

\item{object2}{a model object}

\item{conf.level}{confidence level of the interval}
}
\value{
an object of class \code{icci} containing test results.
}
\description{
\code{icci} calculates confidence intervals of BIC.
Functionality is available for models of classes
lm, glm, glm.nb, clm, hurdle, zeroinfl, mlogit, nls, polr, rlm,
and lavaan.
}
\details{
Users should take care to ensure that the two models have
the same dependent variable (or, for lavaan objects, identical
modeled variables), with observations ordered identically within
each model object.
}
\examples{
\dontrun{
require(MASS)
house1 <- glm(Freq ~ Infl + Type + Cont, family=poisson, data=housing)
house2 <- glm(Freq ~ Infl + Sat, family=poisson, data=housing)

## CI for BIC
icci(house2, house1)

require(pscl)
bio1 <- glm(art ~ fem + mar + phd + ment, family=poisson, data=bioChemists)
bio2 <- hurdle(art ~ fem + mar + phd + ment, data=bioChemists)
bio3 <- zeroinfl(art ~ fem + mar + phd + ment, data=bioChemists)
icci(bio2, bio1)
icci(bio3, bio1)
icci(bio3, bio2)
require(lavaan)
HS.model <- 'visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '
fit1 <- cfa(HS.model, data=HolzingerSwineford1939)
fit2 <- cfa(HS.model, data=HolzingerSwineford1939, group="school")
icci(fit1, fit2, 0.05)
}
}
\author{
Ed Merkle and Dongjun You
}
\references{
Vuong, Q. H. (1989).  Likelihood ratio tests for model selection and non-nested hypotheses.  \emph{Econometrica, 57}, 307-333.

Merkle, E. C., You, D., & Preacher, K. (2014). Testing non-nested structural equation models.  \emph{Manuscript under review}.
}

