% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/concordance.test.R, R/zzz.R
\docType{methods}
\name{getPsi}
\alias{getPsi}
\alias{getPsi,ConcordanceTest,missing-method}
\alias{getPsi,matrix,NULL-method}
\alias{getPsi,matrix,matrix-method}
\alias{getPsi,matrix,missing-method}
\title{Obtain concordance coefficients.}
\usage{
getPsi(x, y, ...)

\S4method{getPsi}{ConcordanceTest,missing}(x)

\S4method{getPsi}{matrix,missing}(x, y, ...)

\S4method{getPsi}{matrix,`NULL`}(x, y, ...)

\S4method{getPsi}{matrix,matrix}(x, y, ...)
}
\arguments{
\item{x}{A numeric matrix or an object \code{\link{ConcordanceTest-class}}}

\item{y}{A numeric matrix (optional)}

\item{...}{Not used}
}
\value{
A numeric vector with coefficient(s)
}
\description{
\code{getPsi} returns the concordance coefficient(s) from a matrix or a result obtained by the \code{\link{concordance.test}} function.
}
\examples{

matRandom <- matrix(rnorm(3*20),20,3)
testResult <- concordance.test(matRandom)
getPsi(testResult)
getPsi(matRandom)
}
\seealso{
Other concordance.functions: \code{\link{coef}},
  \code{\link{concordance.test}}, \code{\link{rfromPsi}}
}

