% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_odd_cc.R
\name{clean_odd_cc}
\alias{clean_odd_cc}
\title{Title: DAT file data frame cleaner.}
\usage{
clean_odd_cc(df)
}
\arguments{
\item{df}{A dirty data frame obtained from the FLUOstar DAT file.}
}
\value{
A clean data frame with clean NA values retained.
}
\description{
The function takes the dirty data frame obtained from reading
the FLUOstar DAT file and applies a function called comma_cleaner() to the dirty data frame,
which automatically inserts NAs in place of the special characters, and rows with NAs only are removed.
}
\examples{
fpath <- system.file("extdata", "dat_3.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
cleaned_dat <- clean_odd_cc(dat_df)
}
\seealso{
\code{\link[=comma_cleaner]{comma_cleaner()}}, \code{\link[=clean_odddat_optimus]{clean_odddat_optimus()}}
}
\author{
Tingwei Adeck
}
