% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluor_threshold_check.R
\name{fluor_threshold_check}
\alias{fluor_threshold_check}
\title{Title: A fluorescence quantification Quality Control (QC) function.}
\usage{
fluor_threshold_check(clean_df, fun = NA)
}
\arguments{
\item{clean_df}{A cleaned data frame.}

\item{fun}{A parameter used for Boolean expressions.}
}
\value{
A polite warning message to the data analyst or researcher.
}
\description{
A function designed to check that fluorescence values do not exceed the upper limit (2^15 or 32768)
OR fall below the lower limit (2^11 or 2048).
Fluorescence values that exceed these thresholds are considered noisy
and lead to incorrect interpretation of analysis results.
}
\note{
Experimental issues should be investigated at very high or very low fluorescence values.
The most common experimental issues arise when ACMA concentrations are out of the tolerated range.
Based on my experience, ACMA concentrations between 2 and 5 Micromolar will suffice
to get fluorescence values within the tolerance threshold.
ACMA concentrations as low as 0.2 Micromolar or as high as 20 Micromolar have proven problematic based on my research experience.

A second issue linked to the FLUOstar instrument revolves around setting the right “gain”
to ensure the right level of sensitivity in machine readings.
A very high “gain” setting results in increased machine sensitivity even
at the right ACMA concentrations and vice versa. In short,
we want the machine to be primed to read exactly what we feed it, no more, no less.

This function provides the attribute(s) and tuple(s) for the values that need investigation.

These deductions were obtained from my experimental hiccups and my characterization of the liposome flux assay system.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odd_cc(dat_df)
resampled_scaled <- resample_dat_scale(nocomma_dat, tnp=3, cycles=40)
resampled_scaled <- resampled_scaled[,c(1:4)]
fluor_threshold_check(resampled_scaled)
}
\seealso{
\code{\link[=fluor_threshold_check_na]{fluor_threshold_check_na()}}, \code{\link[=fluor_threshold_check_raw]{fluor_threshold_check_raw()}}
}
\author{
Tingwei Adeck
}
