% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vavra_test.R
\name{vavra.sample}
\alias{vavra.sample}
\title{vavra test's sieve Bootstrap sample for Anderson Darling statistic}
\usage{
vavra.sample(y,reps = 1000,h = 100,seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A numeric array with the Anderson Darling sieve bootstrap sample
}
\description{
Generates a sieve bootstrap sample of the Anderson-Darling
statistic test.
}
\details{
The Vavra test approximates the empirical distribution function of the
Anderson-Darlings statistic, using a sieve bootstrap approximation.
The test was proposed by \emph{Psaradakis, Z. & Vavra, M (20.17)}.

This function is the equivalent of \code{xarsieve} of
\emph{Psaradakis, Z. &  Vavra, M (20.17)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
adbs = vavra.sample(y)
mean(adbs)

}
\references{
Psaradakis, Z. & Vavra, M. (2017). A distance test of normality for a wide class
of stationary process. \emph{Journal of Econometrics and Statistics}. 2, 50-60.

Bulmann, P. (1997). Sieve Bootstrap for time series. \emph{Bernoulli}.
3(2), 123 -148.
}
\seealso{
\code{\link{epps.statistic}} \code{\link{lobato.statistic}}
}
\author{
Asael Alonzo Matamoros.
}
