% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_t3.R
\name{replext_t3_c2.2}
\alias{replext_t3_c2.2}
\title{Replicate and Extend Statistical Power Analysis from Table 3 Cell 2.2}
\usage{
replext_t3_c2.2(
  M1 = 5,
  S1 = 1,
  M2 = 7,
  S2 = 3,
  Sk1 = 0.8,
  Sk2 = 0.8,
  n1 = c(3, 4, 5, 6, 7, 8, 9, 10, 15, 25, 50, 100),
  n2 = c(3, 4, 5, 6, 7, 8, 9, 10, 15, 25, 50, 100),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 7.}

\item{S2}{Standard deviation for the second group, default is 3.}

\item{Sk1}{Skewness parameter for the first group, default is 0.8.}

\item{Sk2}{Skewness parameter for the second group, default is 0.8.}

\item{n1}{Vector of sample sizes for the first group.}

\item{n2}{Vector of sample sizes for the second group, must be the same length as n1.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame with columns for each sample size pair (n1, n2) and the proportions
of significant p-values for each test (ST, WT, NPBTT, WRST, PTT), representing the power analysis.
}
\description{
This function aims to replicate and extend the statistical power analysis
from Table 3 cell block 2.2 in the paper by Dwivedi et al. (2017). It deals with
scenarios involving skewed distributions with different variances and means
in the two groups. It is a wrapper around \code{replext_t2_c1.1}, with adjusted means,
variances, and skewness parameters.
}
\examples{
replext_t3_c2.2(n1 = c(10), n2 = c(10), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size studies using
nonparametric bootstrap test with pooled resampling method. Stat Med. 2017 Jun 30;36(14):2187-2205.
doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
\seealso{
\code{\link{replext_t2_c1.1}}
}
