% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_t3.R
\name{replext_t3_c5.1}
\alias{replext_t3_c5.1}
\title{Replicate and Extend Statistical Power Analysis from Table 3 Cell 5.1}
\usage{
replext_t3_c5.1(
  M1 = 5,
  S1 = 1,
  M2 = 7,
  S2 = 1,
  Sk1 = NULL,
  Sk2 = NULL,
  n1 = c(3, 4, 5, 6),
  n2 = c(7, 11, 10, 9),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 7.}

\item{S2}{Standard deviation for the second group, default is 1.}

\item{Sk1}{Skewness parameter for the first group, default is NULL (normal distribution).}

\item{Sk2}{Skewness parameter for the second group, default is NULL (normal distribution).}

\item{n1}{Vector of sample sizes for the first group.}

\item{n2}{Vector of unequal sample sizes for the second group.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame with columns for each sample size pair (n1, n2) and the proportions
of significant p-values for each test (ST, WT, NPBTT, WRST, PTT), representing the power analysis.
}
\description{
This function is designed to replicate and extend the statistical power analysis
from Table 3 cell block 5.1 in the paper by Dwivedi et al. (2017). It focuses on
scenarios with normal distribution and unequal sample sizes, using the same
means and variances for both groups. It acts as a wrapper around
\code{replext_t2_c1.1}, with modifications in means and sample sizes.
}
\examples{
replext_t3_c5.1(n1 = c(4), n2 = c(11), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size studies using
nonparametric bootstrap test with pooled resampling method. Stat Med. 2017 Jun 30;36(14):2187-2205.
doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
\seealso{
\code{\link{replext_t2_c1.1}}
}
