% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_join.R
\name{nest_nest_join}
\alias{nest_nest_join}
\title{Nested nest join}
\usage{
nest_nest_join(
  .data,
  .nest_data,
  y,
  by = NULL,
  copy = FALSE,
  keep = FALSE,
  name = NULL,
  ...
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{y}{A data frame, data frame extension (e.g., a tibble), or a lazy data
frame (e.g., from dbplyr or dtplyr).}

\item{by}{A character vector of variables to join by or a join specification
created with \code{join_by()}.

If \code{NULL}, the default, \verb{nest_*_join()} will perform a natural join, using
all variables in common across each object in \code{.nest_data} and \code{y}. A
message lists the variables so you can check they're correct; suppress the
message by supplying \code{by} explicitly.

To join on different variables between the objects in \code{.nest_data} and \code{y},
use a named vector. For example, \code{by = c("a" = "b")} will match
\code{.nest_data$a} to \code{y$b} for each object in \code{.nest_data}.

To join by multiple variables, use a vector with length >1. For example,
\code{by = c("a", "b")} will match \code{.nest_data$a} to \code{y$a} and \code{.nest_data$b} to
\code{y$b} for each object in \code{.nest_data}. Use a named vector to match
different variables in \code{.nest_data} and \code{y}. For example,
\code{by = c("a" = "b", "c" = "d")} will match \code{.nest_data$a} to \code{y$b} and
\code{.nest_data$c} to \code{y$d} for each object in \code{.nest_data}.

To perform a cross-join, generating all combinations of each object in
\code{.nest_data} and \code{y}, use \code{by = character()}.}

\item{copy}{If \code{.nest_data} and \code{y} are not from the same data source and
\code{copy = TRUE} then \code{y} will be copied into the same src as \code{.nest_data}.
\emph{(Need to review this parameter in more detail for applicability with nplyr)}}

\item{keep}{Should the join keys from both \code{.nest_data} and \code{y} be preserved
in the output?}

\item{name}{The name of the list column nesting joins create. If \code{NULL}, the
name of \code{y} is used.}

\item{...}{One or more unquoted expressions separated by commas. Variable
names can be used if they were positions in the data frame, so expressions
like \code{x:y} can be used to select a range of variables.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input.
}
\description{
\code{nest_nest_join()} returns all rows and columns in \code{.nest_data} with a new
nested-df column that contains all matches from \code{y}. When there is no match,
the list contains a 0-row tibble.
}
\details{
\code{nest_nest_join()} is largely a wrapper around \code{\link[dplyr:nest_join]{dplyr::nest_join()}} and
maintains the functionality of \code{nest_join()} within east nested data frame.
For more information on \code{nest_join()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)
gm_codes <- gapminder::country_codes

gm_nest \%>\% nest_nest_join(country_data, gm_codes, by = "country")
}
\seealso{
Other joins: 
\code{\link{nest-filter-joins}},
\code{\link{nest-mutate-joins}}
}
\concept{joins}
