% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_rename.R
\name{nest_rename}
\alias{nest_rename}
\alias{nest_rename_with}
\title{Rename columns in nested data frames}
\usage{
nest_rename(.data, .nest_data, ...)

nest_rename_with(.data, .nest_data, .fn, .cols = dplyr::everything(), ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{For \code{nest_rename()}: Use \code{new_name = old_name} to rename selected variables.

For \code{nest_rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should return a
character vector the same length as the input.}

\item{.cols}{Columns to rename; defaults to all columns.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are not affected.
\item Column names are changed; column order is preserved.
\item Data frame attributes are preserved.
\item Groups are updated to reflect new names.
}
}
\description{
\code{nest_rename()} changes the names of individual variables using
\code{new_name = old_name} syntax; \code{nest_rename_with()} renames columns using a
function.
}
\details{
\code{nest_rename()} and \code{nest_rename_with()} are largely wrappers for
\code{\link[dplyr:rename]{dplyr::rename()}} and \code{\link[dplyr:rename]{dplyr::rename_with()}} and maintain the functionality
of \code{rename()} and \code{rename_with()} within each nested data frame. For more
information on \code{rename()} or \code{rename_with()}, please refer to the
documentation in \href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% nest_rename(country_data, population = pop)
gm_nest \%>\% nest_rename_with(country_data, stringr::str_to_lower)
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_filter}()},
\code{\link{nest_mutate}()},
\code{\link{nest_select}()},
\code{\link{nest_slice}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
