% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOffspring.R
\name{getOffspring}
\alias{getOffspring}
\title{Get offspring to corresponding animal IDs provided}
\usage{
getOffspring(pedSourceDf, ids)
}
\arguments{
\item{pedSourceDf}{dataframe with pedigree structure having at least the
columns id, sire, and dam.}

\item{ids}{character vector of animal IDs}
}
\value{
A character vector containing all of the ancestor IDs for all of the
IDs provided in the second argument \code{ids}. All ancestors are combined
and duplicates are removed.
}
\description{
Get offspring to corresponding animal IDs provided
}
\examples{
library(nprcgenekeepr)
\donttest{
pedOne <- nprcgenekeepr::pedOne
names(pedOne) <- c("id", "sire", "dam", "sex", "birth")
getOffspring(pedOne, c("s1", "d2"))
}
}
