% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParents.R
\name{getParents}
\alias{getParents}
\title{Get parents to corresponding animal IDs provided}
\usage{
getParents(pedSourceDf, ids)
}
\arguments{
\item{pedSourceDf}{dataframe with pedigree structure having at least the
columns id, sire, and dam.}

\item{ids}{character vector of animal IDs}
}
\value{
A character vector with the IDs of the parents of the provided ID
list.
}
\description{
Get parents to corresponding animal IDs provided
}
\examples{
library(nprcgenekeepr)
pedOne <- nprcgenekeepr::pedOne
names(pedOne) <- c("id", "sire", "dam", "sex", "birth")
getParents(pedOne, c("o1", "d4"))
}
