% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattersplot.R
\name{scattersplot}
\alias{scattersplot}
\alias{scattersplot.default}
\alias{scattersplot.SpatialPointsDataFrame}
\title{Exploratory scatter plots}
\usage{
scattersplot(x, ...)

\method{scattersplot}{default}(
  x,
  z,
  main,
  xlab,
  ylab,
  zlab,
  col = hot.colors(128),
  lowess = TRUE,
  density = FALSE,
  omd = c(0.05, 0.95, 0.01, 0.95),
  ...
)

\method{scattersplot}{SpatialPointsDataFrame}(
  x,
  data.ind = 1,
  main,
  xlab,
  ylab,
  zlab,
  col = hot.colors(128),
  lowess = TRUE,
  density = FALSE,
  omd = c(0.05, 0.95, 0.01, 0.95),
  ...
)
}
\arguments{
\item{x}{object used to select a method.}

\item{...}{additional graphical parameters (to be passed to \code{\link{spoints}}).}

\item{z}{vector of data (response variable).}

\item{main}{an overall title for the plot.}

\item{xlab}{a title for the axis corresponding to the first coordinate.}

\item{ylab}{a title for the axis corresponding to the second coordinate.}

\item{zlab}{a title for the axis corresponding to the response.}

\item{col}{color table used to set up the color scale (see \code{\link{spoints}}).}

\item{lowess}{logical. If \code{TRUE}, a \code{\link[stats]{lowess}} smooth is added to 
the plots of the response against the coordinates.}

\item{density}{logical. If \code{TRUE}, a kernel \code{\link[stats]{density}} estimate
is added to the histogram.}

\item{omd}{a vector of the form \code{c(x1, x2, y1, y2)} giving the region inside outer margins 
in normalized device coordinates (i.e. fractions of the device region).}

\item{data.ind}{integer (or character) with the index (or name) of the data component.}
}
\value{
No return value, called for side effects (generate the plot).
}
\description{
Draws (in a 2 by 2 layout) the following plots: 
a scatter plot with a color scale, the scatter plots of the response against the (first two) 
coordinates and the histogram of the response values.
}
\details{
Standard generic function with a default method, in which argument \code{x} 
is a matrix with the spatial coordinates (each row is a point).

\code{scattersplot.SpatialPointsDataFrame} sets default values for some of the arguments 
from attributes of the object \code{x} (if present; see e.g. \code{precipitation}).
}
\seealso{
\code{\link{splot}}, \code{\link{spoints}}, \code{\link[stats]{lowess}}, 
\code{\link[stats]{density}}
}
\keyword{hplot}
