% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gpr2sample}
\alias{gpr2sample}
\title{Performs two-sample GP regression}
\usage{
gpr2sample(x.ctrl, y.ctrl, x.case = NULL, y.case, x.targets,
  noise.ctrl = NULL, noise.case = NULL, nsnoise = TRUE, nskernel = TRUE,
  expectedmll = FALSE, params.ctrl = NULL, params.case = NULL,
  defaultparams = NULL, lbounds = NULL, ubounds = NULL,
  lockatzero = FALSE, optim.restarts = 3, derivatives = FALSE)
}
\arguments{
\item{x.ctrl}{input points (control)}

\item{y.ctrl}{output values (control)}

\item{x.case}{input points (case)}

\item{y.case}{output values (case)}

\item{x.targets}{target points}

\item{noise.ctrl}{observational noise}

\item{noise.case}{observational noise}

\item{nsnoise}{estimate non-stationary noise function from replicates, if available}

\item{nskernel}{use non-stationary kernel (default)}

\item{expectedmll}{use expected MLL optimization criteria}

\item{params.ctrl}{kernel parameters (control)}

\item{params.case}{kernel parameters (case)}

\item{defaultparams}{initial parameters for optimization}

\item{lbounds}{lower bounds for parameter optimization}

\item{ubounds}{upper bounds for parameter optimization}

\item{lockatzero}{estimate a pseudo-observation for time 0}

\item{optim.restarts}{restarts in the gradient ascent (default=3)}

\item{derivatives}{compute also GP derivatives}
}
\value{
a \code{gppack}-object that contains
\item{ctrlmodel}{the gp-object corresponding to the control data}
\item{casemodel}{the gp-object corresponding to the case data}
\item{nullmodel}{the gp-object corresponding to the shared null data}
\item{ratios}{the log likelihood ratios between the control and case against the null model, contains..}
\item{______$mll}{marginal log likelihood ratio}
\item{______$emll}{expected marginal log likelihood ratio}
\item{______$pc}{log posterior concentration ratio}
\item{______$npc}{log noisy posterior concentration ratio}
}
\description{
Performs gaussian process regression for two time-series: control and case.
 A third null GP model is learned that assumes both data coming from same process.
 Various likelihood ratios between the null and individual models are estimated to
 distinguish when case and control processes are significantly different. Use \code{\link{plot.gppack}}
 to visualize the models.
}
\details{
The control and case do not need have same amount of points. The resulting \code{gppack} object
 contains the three learned models and the likelihood ratios along \code{x.targets}.
}
\examples{
# read toy data
data(toydata)

\dontrun{can take several minutes
 # perform two-sample regression
 res = gpr2sample(toydata$ctrl$x, toydata$ctrl$y, toydata$case$x, toydata$case$y, seq(0,22,0.1))
 print(res)}

# pre-computed model for toydata
data(toygps)
print(toygps)
}
\seealso{
\code{\link{gpr1sample}} \code{\link{plot.gppack}}
}

