% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsrr_download.R
\name{nsrr_download_url}
\alias{nsrr_download_url}
\alias{nsrr_download_file}
\title{NSRR Download file}
\usage{
nsrr_download_url(dataset, path, token = nsrr_token())

nsrr_download_file(dataset, path, token = nsrr_token(),
  check_md5 = TRUE)
}
\arguments{
\item{dataset}{a dataset \code{"slug"}, one from
\code{\link{nsrr_datasets}}}

\item{path}{full path to the file.}

\item{token}{Token for NSRR resources.  Found at
\url{https://sleepdata.org/token}}

\item{check_md5}{check if MD5 checksum agrees when downloaded}
}
\value{
A \code{data.frame} of the data sets and their endpoints
}
\description{
NSRR Download file
}
\examples{
dataset = "shhs"
path = "datasets/shhs-data-dictionary-0.13.2-domains.csv"
nsrr_download_url(dataset, path, token = "")
if (nsrr_have_token()) {
res = nsrr_download_file(dataset, path)
testthat::expect_true(res$success)
path = "biostatistics-with-r/shhs1.txt"
res = nsrr_download_file(dataset, path)
}
url = nsrr_download_url("shhs", path = "datasets/CHANGELOG.md",
token = NULL)
res = nsrr_download_file("shhs", path = "datasets/CHANGELOG.md",
token = NULL)
testthat::expect_true(res$correct_md5)
res = nsrr_download_file("shhs", path = "datasets/CHANGELOG.md",
token = NULL, check_md5 = FALSE)
testthat::expect_null(res$correct_md5)
}
