% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spots_combined.R
\name{spots.combined.folder}
\alias{spots.combined.folder}
\title{Find spots using information from two channels for folder}
\usage{
spots.combined.folder(
  path,
  size = NULL,
  voxelsize = NULL,
  thresh.offset = 0.1,
  min.sum.intensity = 2,
  max.distance = 0.5,
  use.brightest = FALSE,
  max.spots = 2,
  full.voxel = FALSE,
  output = "markers",
  cores = 1
)
}
\arguments{
\item{path}{path to folder}

\item{size}{size of img in microns, if size and voxelsize are NULL, size is determined from folder XYZmic}

\item{voxelsize}{size of voxel in microns}

\item{thresh.offset}{Thresh offset used in EBImage::thresh()}

\item{min.sum.intensity}{spots smaller than min.sum.intensity are ignored}

\item{max.distance}{use only spots with distance to other color spot smaller than max.distance}

\item{use.brightest}{Logical; use only brightest in max.distance?}

\item{max.spots}{maximum of spots (per channel), only when use brightest=TRUE}

\item{full.voxel}{Logical; output contains full voxel instead of rgb intensities}

\item{output}{output folder}

\item{cores}{number of cores we can use of parallel computing (needs parallel package if cores>1)}
}
\value{
RGB image with spots will be written to output folder
}
\description{
Find spots using information from two channels for folder
}
