% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_almost_constant.R
\name{remove_almost_constant}
\alias{remove_almost_constant}
\title{Remove almost constant columns from a data frame}
\usage{
remove_almost_constant(
  .data,
  .what = everything(),
  ...,
  .threshold = 1,
  .na_rm = FALSE,
  .verbose = FALSE
)
}
\arguments{
\item{.data}{A data frame.}

\item{.what}{A tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to process.}

\item{...}{Additional tidyselect expressions selecting more columns.}

\item{.threshold}{Numeric scalar in the interval \eqn{[0,1]} giving the
minimum required proportion of the most frequent value for a column to be
considered almost constant.}

\item{.na_rm}{Logical; if \code{TRUE}, \code{NA} values are removed before computing
proportions. If \code{FALSE}, \code{NA} is treated as a regular value. See
\code{\link[=is_almost_constant]{is_almost_constant()}} for details.}

\item{.verbose}{Logical; if \code{TRUE}, print a message listing the removed
columns.}
}
\value{
A data frame with all selected columns removed that meet the
definition of being almost constant.
}
\description{
Test all columns specified by \code{.what} and remove those that are almost
constant. A column is considered almost constant if the proportion of its
most frequent value is greater than or equal to the threshold specified by
\code{.threshold}. See \code{\link[=is_almost_constant]{is_almost_constant()}} for further details.
}
\examples{
d <- data.frame(a1 = 1:10,
                a2 = c(1:9, NA),
                b1 = "b",
                b2 = NA,
                c1 = rep(c(TRUE, FALSE), 5),
                c2 = rep(c(TRUE, NA), 5),
                d  = c(rep(TRUE, 4), rep(FALSE, 4), NA, NA))

# Remove columns that are constant (threshold = 1)
remove_almost_constant(d, .threshold = 1.0, .na_rm = FALSE)
remove_almost_constant(d, .threshold = 1.0, .na_rm = TRUE)

# Remove columns where the majority value occurs in >= 50\% of rows
remove_almost_constant(d, .threshold = 0.5, .na_rm = FALSE)
remove_almost_constant(d, .threshold = 0.5, .na_rm = TRUE)

# Restrict check to a subset of columns
remove_almost_constant(d, a1:b2, .threshold = 0.5, .na_rm = TRUE)

}
\seealso{
\code{\link[=is_almost_constant]{is_almost_constant()}}, \code{\link[=remove_ill_conditions]{remove_ill_conditions()}}
}
\author{
Michal Burda
}
