% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberize.R
\name{numberize}
\alias{numberize}
\title{Convert a vector string of spelled numbers in a supported language to
its numeric equivalent.}
\usage{
numberize(text, lang = c("en", "fr", "es"))
}
\arguments{
\item{text}{String vector of spelled numbers in a supported language.}

\item{lang}{The text's language. Currently one of \code{c("en", "fr", "es")}.
Default is "en"}
}
\value{
A numeric vector.
}
\description{
The range of words supported is between \strong{zero} and
\strong{nine hundred and ninety nine trillion, nine hundred and}
\strong{ninety nine billion, nine hundred and ninety nine million, nine}
\strong{hundred and ninety nine thousand, nine hundred and ninety nine}
}
\examples{
# convert to numbers a scalar
numberize("five hundred and thirty eight")

# convert a vector of values
numberize(c("dix", "soixante-cinq", "deux mille vingt-quatre"), lang = "fr")

}
