% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_month.R
\name{f_month}
\alias{f_month}
\alias{f_month.default}
\alias{f_month.numeric}
\alias{f_month.Date}
\alias{f_month.POSIXt}
\alias{f_month.hms}
\alias{ff_month}
\alias{f_month_name}
\alias{f_month_name.default}
\alias{f_month_name.numeric}
\alias{f_month_name.Date}
\alias{f_month_name.POSIXt}
\alias{f_month_name.hms}
\alias{ff_month_name}
\alias{f_month_abbreviation}
\alias{f_month_abbreviation.default}
\alias{f_month_abbreviation.numeric}
\alias{f_month_abbreviation.Date}
\alias{f_month_abbreviation.POSIXt}
\alias{f_month_abbreviation.hms}
\alias{ff_month_abbreviation}
\title{Format Months to One Letter Abbreviation}
\usage{
f_month(x, ...)

\method{f_month}{default}(x, ...)

\method{f_month}{numeric}(x, ...)

\method{f_month}{Date}(x, ...)

\method{f_month}{POSIXt}(x, ...)

\method{f_month}{hms}(x, ...)

ff_month(...)

f_month_name(x, ...)

\method{f_month_name}{default}(x, ...)

\method{f_month_name}{numeric}(x, ...)

\method{f_month_name}{Date}(x, ...)

\method{f_month_name}{POSIXt}(x, ...)

\method{f_month_name}{hms}(x, ...)

ff_month_name(...)

f_month_abbreviation(x, ...)

\method{f_month_abbreviation}{default}(x, ...)

\method{f_month_abbreviation}{numeric}(x, ...)

\method{f_month_abbreviation}{Date}(x, ...)

\method{f_month_abbreviation}{POSIXt}(x, ...)

\method{f_month_abbreviation}{hms}(x, ...)

ff_month_abbreviation(...)
}
\arguments{
\item{x}{A vector of month names, integers 1-12, or dates.}

\item{\ldots}{ignored.}
}
\value{
Returns a single letter month abbreviation atomic vector.
}
\description{
Format long month name, integer, or date formats to a single capital letter.
Useful for plot scales as a way to save space.
}
\examples{
f_month(month.name)

f_month(1:12)

dates <- seq(as.Date("2000/1/1"), by = "month", length.out = 12)
f_month(dates)
\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse)

set.seed(11)
data_frame(
    date = sample(seq(as.Date("1990/1/1"), by = "day", length.out = 2e4), 12)
) \%>\%
    mutate(
        year_4 = f_year(date, 2),
        year_2 = f_year(date, 4),
        quarter = f_quarter(date),
        month_name = f_month_name(date) \%>\%
            as_factor(),
        month_abbreviation = f_month_abbreviation(date) \%>\%
            as_factor(),
        month_short = f_month(date),
        weekday_name = f_weekday_name(date),
        weekday_abbreviation = f_weekday_abbreviation(date),
       weekday_short = f_weekday(date),
        weekday_short_distinct = f_weekday(date, distinct = TRUE)
    )


set.seed(10)
dat <- data_frame(
    month = sample(month.name, 1000, TRUE),
    area =  sample(LETTERS[1:5], 1000, TRUE)
) \%>\%
    count(month, area) \%>\%
    ungroup() \%>\%
    mutate(month = factor(month, levels = constant_months))

## without date formatting
ggplot(dat, aes(month, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~ area)

## with date formatting
ggplot(dat, aes(month, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~ area) +
    scale_x_discrete(labels = f_month)
}
}
