% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_wrap.R
\name{f_wrap}
\alias{f_wrap}
\alias{ff_wrap}
\title{Wrap Strings}
\usage{
f_wrap(
  x,
  width = 15,
  sep = "\\n",
  exdent = 0,
  indent = 0,
  equal.lines = FALSE,
  collapse = FALSE,
  ...
)

ff_wrap(...)
}
\arguments{
\item{x}{A vector of text strings.}

\item{width}{A positive integer giving the target column for wrapping lines
in the output.}

\item{sep}{A new line separator (defaults to \code{"\\n"}.}

\item{exdent}{A non-negative integer specifying the indentation of subsequent
lines in paragraphs.}

\item{indent}{A non-negative integer giving the indentation of the first line
in a paragraph.}

\item{equal.lines}{logical.  If \code{TRUE} the number of lines for each
element will be made the same by appending additional '\\n' to those below
the max number of lines.  This is useful for legend spacing.}

\item{collapse}{logical. If \code{TRUE} then \code{x} is collapsed via
\code{paste(x, collapse = ' ')} before processing.  This is useful for
muti-line text wrapping of longer subtitles.}

\item{\ldots}{Other arguments passed to \code{\link[base]{strwrap}}.}
}
\value{
Returns a string vector with wrapped new line characters.
}
\description{
Wrap strings by splitting n width, and paste collapsing with new line
characters.
}
\examples{
cat(f_wrap('really long label names are the pits'))
cat(f_wrap('really long label names are the pits', width = 20, exdent = 2))
f_wrap(c('really long label names are the pits and make us sad',
    'not nearly so long'), equal.lines = TRUE)

\dontrun{
library(tidyverse); library(gridExtra)

set.seed(10)
dat <- data_frame(
    level = c('Not Involved', 'Somewhat Involved Single Group',
        'Somewhat Involved Multiple Groups', 'Very Involved One Group',
        'Very Involved Multiple Groups'
    ),
    n = sample(1:10, length(level))
) \%>\%
    mutate(
        level = factor(level, levels = unique(level)),
        `\%` = n/sum(n)
    )

gridExtra::grid.arrange(
    dat \%>\%
        ggplot(aes(level, `\%`)) +
            geom_col() +
            labs(title = 'Yucky Labels', y = NULL),

    dat \%>\%
        ggplot(aes(level, `\%`)) +
            geom_col() +
            scale_x_discrete(labels = f_wrap) +
            scale_y_continuous(labels = ff_prop2percent(digits = 0)) +
            labs(title = 'Happy Labels', y = NULL),

    ncol = 1, heights = c(.45, .55)
)

}
}
\seealso{
\code{\link[base]{strwrap}}
}
