% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getGraphIdsWithParticipant}
\alias{getGraphIdsWithParticipant}
\title{Gets a list of IDs of graphs that include the given participant.}
\usage{
getGraphIdsWithParticipant(labbcat.url, id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A participant ID}
}
\value{
A list of graph IDs
}
\description{
Returns a list of IDs of graphs (i.e. transcript names) that include
the given participant.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## specify the username/password in the script
## (only use labbcatCredentials for scripts that must execute unsupervised!)
labbcatCredentials(labbcat.url, "demo", "demo")

## List transcripts in which UC427_ViktoriaPapp_A_ENG speaks
transcripts <- getGraphIdsWithParticipant(labbcat.url, "UC427_ViktoriaPapp_A_ENG")
}

}
\seealso{
\code{\link{getParticipantIds}}
}
\keyword{graph}
\keyword{transcript}
