% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcatCredentials}
\alias{labbcatCredentials}
\title{Sets the username and password that the package should use for connecting
to a given LaBB-CAT server in future function calls.}
\usage{
labbcatCredentials(labbcat.url, username, password)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{username}{The LaBB-CAT username, if it is password-protected}

\item{password}{The LaBB-CAT password, if it is password-protected}
}
\value{
FALSE if the username/password are incorrect,
NULL if they username/password are correct but the version of LaBB-CAT
is incompatible with the package, and TRUE otherwise.
}
\description{
This step is optional, as all functions will prompt the user for the username
and password if required.  If the script is running in RStudio, then the
RStudio password input dialog is used, hiding the credentials from view.
Otherwise, the console is used, and credentials are visible.
}
\details{
The recommended approach is to *not* use labbcatCredentials, to avoid saving
user credentials in script files that may eventually become visible to other.
Use labbcatCredentials *only* in cases where the script execution is unsupervised.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## connect to a password-protected instance of LaBB-CAT with explicit credentials
labbcatCredentials(labbcat.url, "demo", "demo")
}

}
\keyword{connect}
\keyword{password}
\keyword{timeout}
\keyword{username}
