% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionFromTranscriptTypes.R
\name{expressionFromTranscriptTypes}
\alias{expressionFromTranscriptTypes}
\title{Generates a transcript query expression for matching transcripts by type, for use with
\link{getMatches} or \link{getMatchingTranscriptIds}.}
\usage{
expressionFromTranscriptTypes(transcript.types, not = FALSE)
}
\arguments{
\item{transcript.types}{A list of transcript types.}

\item{not}{Whether to match the given IDs (FALSE), or everything *except* the
given IDs.}
}
\value{
A transcript query expression which can be passed as the
transcript.expression parameter of \link{getMatches} or the expression parameter
of \link{getMatchingTranscriptIds}
}
\description{
This function generates a transcript query expression fragment which can be passed as
the transcript.expression parameter of \link{getMatches}, (or the expression parameter
of \link{getMatchingTranscriptIds}) in order to identify transcripts using a list of
transcript types.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Perform a search of interviews or monologues
transcript.types <- c("interview","monologue")
results <- getMatches(labbcat.url, list(segment="I"),
  transcript.expression = expressionFromTranscriptTypes(transcript.types))

## Perform a search of all transcripts that aren't word-lists.
results <- getMatches(labbcat.url, list(segment="I"),
  transcript.expression = expressionFromTranscriptTypes("wordlist", NOT=true))
}
}
\seealso{
\link{expressionFromAttributeValue}

\link{expressionFromAttributeValues}

\link{expressionFromIds}

\link{getMatches}
}
\keyword{search}
