% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFragments.R
\name{getFragments}
\alias{getFragments}
\title{Gets transcript fragments in a given format.}
\usage{
getFragments(
  labbcat.url,
  id,
  start,
  end,
  layer.ids,
  mime.type = "text/praat-textgrid",
  path = ""
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The transcript ID (transcript name) of the sound recording, or
a vector of transcript IDs.}

\item{start}{The start time in seconds, or a vector of start times.}

\item{end}{The end time in seconds, or a vector of end times.}

\item{layer.ids}{A vector of layer IDs.}

\item{mime.type}{Optional content-type - "text/praat-textgrid" is the default, but your
LaBB-CAT installation may support other formats, which can be discovered using
\link{getSerializerDescriptors}.}

\item{path}{Optional path to directory where the files should be saved.}
}
\value{
The name of the file, which is saved in the current
    directory, or a list of names of files, if multiple
    id's/start's/end's were specified 

If a list of files is returned, they are in the order that they
    were returned by the server, which *should* be the order that
    they were specified in the id/start/end lists.
}
\description{
This function gets fragments of transcripts from 'LaBB-CAT', 
converted to a given format (by default, Praat TextGrid).
}
\details{
\emph{NB} Although many formats will generate exactly one file for each interval
     (e.g. mime.type=text/praat-textgrid), this is not guaranted; some formats generate
     a single file or a fixed collection of files regardless of how many fragments there are.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get the 5 seconds starting from 10s after the beginning of a recording
textgrid.file <- getFragments(labbcat.url, "AP2505_Nelson.eaf", 10.0, 15.0,
    c("transcript", "phonemes"), path="samples") 

## Load some search results previously exported from LaBB-CAT
results <- read.csv("results.csv", header=T)

## Get a list of fragment TextGrids, including the utterances, transcript, and phonemes layers
textgrid.files <- getFragments(
    labbcat.url, results$Transcript, results$Line, results$LineEnd,
    c("utterance", "word", "phonemes"))

## Get a list of fragment TextGrids
textgrid.files <- getFragments(
    labbcat.url, results$Transcript, results$Line, results$LineEnd)
}
}
\seealso{
\link{getSerializerDescriptors}
}
\keyword{TextGrid}
\keyword{fragment}
\keyword{sample}
