% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeDictionaryEntry.R
\name{removeDictionaryEntry}
\alias{removeDictionaryEntry}
\title{Removes an entry from a dictionary.}
\usage{
removeDictionaryEntry(
  labbcat.url,
  manager.id,
  dictionary.id,
  key,
  entry = NULL
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{manager.id}{The layer manager ID of the dictionary, as returned by getDictionaries}

\item{dictionary.id}{The ID of the dictionary, as returned by getDictionaries}

\item{key}{The key (word) in the dictionary to remove an entry for.}

\item{entry}{The value (definition) for the given key, or NULL to remove all entries
for the key.}
}
\value{
NULL if the entry was removed, or a list of error messages if not.
}
\description{
This function removes an existing entry from the given dictionary.
}
\details{
You must have edit privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Remove a pronuciation of the word "robert" from the CELEX wordform pronunciation dictionary
removeDictionaryEntry(labbcat.url, "CELEX-EN", "Phonology (wordform)", "robert", "'rQ-bErt")
}

}
\seealso{
\link{getDictionaries}

\link{getDictionaryEntries}
}
\keyword{annotation}
\keyword{layer}
