% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveLayer.R
\name{saveLayer}
\alias{saveLayer}
\title{Saves the details of an existing layer.}
\usage{
saveLayer(labbcat.url, layer)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{layer}{A named list object representing the layer attributes, as would be
returned by \link{getLayer} or \link{newLayer}, with members:
\itemize{
 \item{\emph{id} The layer's unique ID}
 \item{\emph{parentId} The layer's parent layer ID}
 \item{\emph{description} The description of the layer}
 \item{\emph{alignment} The layer's alignment - 0 for none, 1 for point alignment, 2
    for interval alignment} 
 \item{\emph{peers} Whether children have peers or not}
 \item{\emph{peersOverlap} Whether child peers can overlap or not}
 \item{\emph{parentIncludes} Whether the parent t-includes the child}
 \item{\emph{saturated} Whether children must temporally fill the entire parent
    duration (true) or not (false)} 
 \item{\emph{parentIncludes} Whether the parent t-includes the child}
 \item{\emph{type} The type for labels on this layer}
 \item{\emph{validLabels} List of valid label values for this layer}
}}
}
\value{
The resulting layer definition, with members:
    \itemize{
     \item{\emph{id} The layer's unique ID}
     \item{\emph{parentId} The layer's parent layer ID}
     \item{\emph{description} The description of the layer}
     \item{\emph{alignment} The layer's alignment - 0 for none, 1 for point alignment, 2
        for interval alignment} 
     \item{\emph{peers} Whether children have peers or not}
     \item{\emph{peersOverlap} Whether child peers can overlap or not}
     \item{\emph{parentIncludes} Whether the parent t-includes the child}
     \item{\emph{saturated} Whether children must temporally fill the entire parent
        duration (true) or not (false)} 
     \item{\emph{parentIncludes} Whether the parent t-includes the child}
     \item{\emph{type} The type for labels on this layer}
     \item{\emph{validLabels} List of valid label values for this layer}
    }
}
\description{
This function saves the definition of an existing annotation layer.
}
\details{
You must have administration privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Get the pronunciation layer definition
pronunciation <- getLayer(labbcat.url, "pronunciation")

## Change some details of the definition
pronunciation$description <- "CMU Dict pronunciations encoded in DISC"
pronunciation$type <- "ipa"

## Save the changes to the layer definition
saveLayer(labbcat.url, pronunciation)
}

}
\seealso{
\code{\link{newLayer}}
\code{\link{getLayer}}
\code{\link{deleteLayer}}
}
\keyword{annotation}
\keyword{layer}
