% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_poisson.R
\name{hmm_simulate_gamma_poisson_data}
\alias{hmm_simulate_gamma_poisson_data}
\title{Simulate data distributed according to oHMMed with gamma-poisson emission densities}
\usage{
hmm_simulate_gamma_poisson_data(L, mat_T, betas, alpha)
}
\arguments{
\item{L}{(integer) number of simulations}

\item{mat_T}{(matrix) a square matrix with the initial state}

\item{betas}{(numeric) \code{rate} parameter in \code{\link{rgamma}} for emission probabilities}

\item{alpha}{(numeric) \code{shape} parameter in \code{\link{rgamma}} for emission probabilities}
}
\value{
Returns a list with the following elements:
\itemize{
  \item \code{data}: numeric vector with data
  \item \code{states}: an integer vector with "true" hidden states used to generate the data vector
  \item \code{pi}: numeric vector with prior probability of states
}
}
\description{
Simulate data distributed according to oHMMed with gamma-poisson emission densities
}
\examples{
mat_T <- rbind(c(1-0.01, 0.01, 0),
               c(0.01, 1-0.02, 0.01),
               c(0, 0.01, 1-0.01))
L <- 2^7
betas <- c(0.1, 0.3, 0.5)
alpha <- 1

sim_data <- hmm_simulate_gamma_poisson_data(L = L,
                                            mat_T = mat_T,
                                            betas = betas,
                                            alpha = alpha)
hist(sim_data$data, 
     breaks = 40,
     main = "Histogram of Simulated Gamma-Poisson Data", 
     xlab = "")
sim_data
}
