% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_shortterm_demand_data}
\alias{example_shortterm_demand_data}
\title{Example Short-term Demand Data}
\format{
A data frame with 43,800 rows and 14 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{date}}{The date (in \code{YYYY-MM-DD} format).}
\item{\code{year}}{The respective year.}
\item{\code{month}}{The respective month.}
\item{\code{day}}{The respective day.}
\item{\code{wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{hour}}{The respective hour of the day.}
\item{\code{hourly_demand}}{The actual hourly electricity demand (in megawatts).}
\item{\code{hourly_demand_trend_corrected}}{The hourly demand corrected for long-term trends.}
\item{\code{yearly}}{The yearly average electricity demand.}
\item{\code{daily}}{The daily average electricity demand.}
\item{\code{hourly_demand_trend_and_season_corrected}}{The hourly demand corrected for both long-term trends and seasonal variations.}
\item{\code{holiday}}{A binary indicator for whether the day is a public holiday (\code{1} for holiday, \code{0} for non-holiday).}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/
}
\usage{
example_shortterm_demand_data
}
\description{
This dataset contains the seasonal short-term demand (the difference between the measured hourly demand and the yearly average hourly electricity demand minus the daily average hourly electricity demand).
for each hour for France from 2017 until 2021. The short-term seasonality corresponds to the intra-day pattern.
}
\keyword{dataset}
\keyword{demand}
\keyword{shortterm}
