% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_records.R
\name{list_records}
\alias{list_records}
\title{List records}
\usage{
list_records(url = "http://api.gbif.org/v1/oai-pmh/registry",
  prefix = "oai_dc", from = NULL, until = NULL, set = NULL,
  token = NULL, as = "df", ...)
}
\arguments{
\item{url}{(character) OAI-PMH base url. Defaults to the URL for
arXiv's OAI-PMH server (http://export.arxiv.org/oai2)
or GBIF's OAI-PMH server (http://api.gbif.org/v1/oai-pmh/registry)}

\item{prefix}{specifies the metadata format that the records will be
returned in. Default: \code{oai_dc}}

\item{from}{specifies that records returned must have been
created/update/deleted on or after this date.}

\item{until}{specifies that records returned must have been
created/update/deleted on or before this date.}

\item{set}{specifies the set that returned records must belong to.}

\item{token}{(character) a token previously provided by the server to
resume a request where it last left off. 50 is max number of records
returned. We will loop for you internally to get all the records you
asked for.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List records
}
\examples{
\dontrun{
# By default you get back a single data.frame
list_records(from = '2018-05-01T00:00:00Z', until = '2018-05-03T00:00:00Z')
list_records(from = '2018-05-01T', until = '2018-05-04T')

# Get a list
list_records(from = '2018-05-01T', until = '2018-05-04T', as = "list")

# Get raw text
list_records(from = '2018-05-01T', until = '2018-05-04T', as = "raw")
list_records(from = '2018-05-01T', until = '2018-05-04T', as = "raw")

# Use a resumption token
# list_records(token =
#  "1443799900201,2015-09-01T00:00:00Z,2015-10-01T23:59:59Z,50,null,oai_dc")
}
}
