% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{label}
\alias{label}
\alias{label<-}
\alias{labels.rtree}
\title{Labels of nodes and trees}
\usage{
label(.node)

label(x) <- value

\method{labels}{rtree}(object, ...)
}
\arguments{
\item{.node, x}{A node.}

\item{value}{character. New label to be applied to the node.}

\item{...}{Additional arguments (not used).}

\item{.tree, object}{A tree.}
}
\description{
Get the label of a node or the labels of all nodes 
of a tree.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
labels(tr0)
labels(tr1)
labels(tr2)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
labels(tr3)

}
