context("Test 'parent()' functions")

test_that("function 'parent()' works properly", {
  
  tr0 = c_("Bob", "Carl", "Daniel")
  expect_identical(empty_tree(), parent("Bob", tr0))
  expect_identical("Bob", label(parent("Carl", tr0)))
  expect_identical("Carl", label(parent("Daniel", tr0)))
  expect_true(is.node(parent("Carl", tr0)))
  expect_true(is.node(parent("Daniel", tr0)))
  expect_false(has.parent("Bob", tr0))
  expect_false(has.parent("TOTO", tr0))
  expect_true(has.parent("Carl", tr0))
  expect_true(has.parent("Daniel", tr0))
  
  tr1 = r_("Dimitri", s = list(c_("Enoc"), c_("Ferdinand")))
  expect_identical(empty_tree(), parent("Dimitri", tr1))
  expect_identical("Dimitri", label(parent("Enoc", tr1)))
  expect_identical("Dimitri", label(parent("Ferdinand", tr1)))
  expect_true(is.node(parent("Enoc", tr1)))
  expect_true(is.node(parent("Ferdinand", tr1)))
  expect_false(has.parent("Dimitri", tr1))
  expect_false(has.parent("TOTO", tr1))
  expect_true(has.parent("Enoc", tr1))
  expect_true(has.parent("Ferdinand", tr1))
  
  tr1 = r_("Caroline", s = list(tr1))
  expect_identical(empty_tree(), parent("Caroline", tr1))
  expect_identical("Caroline", label(parent("Dimitri", tr1)))
  expect_identical("Dimitri", label(parent("Enoc", tr1)))
  expect_identical("Dimitri", label(parent("Ferdinand", tr1)))
  expect_true(is.node(parent("Dimitri", tr1)))
  expect_true(is.node(parent("Enoc", tr1)))
  expect_true(is.node(parent("Ferdinand", tr1)))
  expect_false(has.parent("Caroline", tr1))
  expect_false(has.parent("TOTO", tr1))
  expect_true(has.parent("Dimitri", tr1))
  expect_true(has.parent("Enoc", tr1))
  expect_true(has.parent("Ferdinand", tr1))
  
  tr1 = r_("Bill", s = list(tr1))
  expect_identical(empty_tree(), parent("Bill", tr1))
  expect_identical("Bill", label(parent("Caroline", tr1)))
  expect_identical("Caroline", label(parent("Dimitri", tr1)))
  expect_identical("Dimitri", label(parent("Enoc", tr1)))
  expect_identical("Dimitri", label(parent("Ferdinand", tr1)))
  expect_true(is.node(parent("Caroline", tr1)))
  expect_true(is.node(parent("Dimitri", tr1)))
  expect_true(is.node(parent("Enoc", tr1)))
  expect_true(is.node(parent("Ferdinand", tr1)))
  expect_false(has.parent("Bill", tr1))
  expect_false(has.parent("TOTO", tr1))
  expect_true(has.parent("Caroline", tr1))
  expect_true(has.parent("Dimitri", tr1))
  expect_true(has.parent("Enoc", tr1))
  expect_true(has.parent("Ferdinand", tr1))
  
  tr2 = r_("Alice", s = list(tr0, tr1))
  expect_identical(empty_tree(), parent("Alice", tr2))
  expect_identical("Alice", label(parent("Bob", tr2)))
  expect_identical("Alice", label(parent("Bill", tr2)))
  expect_identical("Bob", label(parent("Carl", tr2)))
  expect_identical("Carl", label(parent("Daniel", tr2)))
  expect_identical("Bill", label(parent("Caroline", tr2)))
  expect_identical("Caroline", label(parent("Dimitri", tr2)))
  expect_identical("Dimitri", label(parent("Enoc", tr2)))
  expect_identical("Dimitri", label(parent("Ferdinand", tr2)))
  expect_true(is.node(parent("Bob", tr2)))
  expect_true(is.node(parent("Bill", tr2)))
  expect_true(is.node(parent("Carl", tr2)))
  expect_true(is.node(parent("Daniel", tr2)))
  expect_true(is.node(parent("Caroline", tr2)))
  expect_true(is.node(parent("Dimitri", tr2)))
  expect_true(is.node(parent("Enoc", tr2)))
  expect_true(is.node(parent("Ferdinand", tr2)))
  expect_false(has.parent("Alice", tr2))
  expect_false(has.parent("TOTO", tr2))
  expect_true(has.parent("Bob", tr2))
  expect_true(has.parent("Carl", tr2))
  expect_true(has.parent("Daniel", tr2))
  expect_true(has.parent("Bill", tr2))
  expect_true(has.parent("Caroline", tr2))
  expect_true(has.parent("Dimitri", tr2))
  expect_true(has.parent("Enoc", tr2))
  expect_true(has.parent("Ferdinand", tr2))

  ## Unrooted tree
  tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son")))
  expect_identical(empty_tree(), parent("Alice", tr3))
  expect_identical("Alice", label(parent("Bob", tr3)))
  expect_identical("Alice", label(parent("Bill", tr3)))
  expect_identical("Bob", label(parent("Carl", tr3)))
  expect_identical("Carl", label(parent("Daniel", tr3)))
  expect_identical("Bill", label(parent("Caroline", tr3)))
  expect_identical("Caroline", label(parent("Dimitri", tr3)))
  expect_identical("Dimitri", label(parent("Enoc", tr3)))
  expect_identical("Dimitri", label(parent("Ferdinand", tr3)))
  expect_true(is.node(parent("Bob", tr3)))
  expect_true(is.node(parent("Bill", tr3)))
  expect_true(is.node(parent("Carl", tr3)))
  expect_true(is.node(parent("Daniel", tr3)))
  expect_true(is.node(parent("Caroline", tr3)))
  expect_true(is.node(parent("Dimitri", tr3)))
  expect_true(is.node(parent("Enoc", tr3)))
  expect_true(is.node(parent("Ferdinand", tr3)))
  expect_false(has.parent("Alice", tr3))
  expect_false(has.parent("TOTO", tr3))
  expect_true(has.parent("Bob", tr3))
  expect_true(has.parent("Carl", tr3))
  expect_true(has.parent("Daniel", tr3))
  expect_true(has.parent("Bill", tr3))
  expect_true(has.parent("Caroline", tr3))
  expect_true(has.parent("Dimitri", tr3))
  expect_true(has.parent("Enoc", tr3))
  expect_true(has.parent("Ferdinand", tr3))
  
})
