% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_entropy.R
\name{calculate_entropy}
\alias{calculate_entropy}
\title{Calculate the entropy of each action in the design}
\usage{
calculate_entropy(design, priors = NULL)
}
\arguments{
\item{design}{A matrix with rows equal to the number of rules and columns
equal to the number of actions or a list of such matrices.}

\item{priors}{A vector of prior values. If the design is a list of matrices,
priors can be a matrix with rows equal to the length of the design and columns
equal to the number of rules.}
}
\value{
A list of of vectors of entropies for each possible action with the
following attributes:
\enumerate{
  \item design
  \item priors
  \item pr_aj_rk
  \item pr_rk_aj
}
}
\description{
The function is a wrapper for \code{\link{calc_entropy}} and is meant for
external use by the user. The goal for the decision maker is
to choose an action such that the observer is left as clueless as possible 
as to which rule governs his actions, i.e. maximize entropy.
}
\examples{
    design <- matrix(c(-1, -1, -1, -1,  1,
                       -1,  0,  0, -1,  0,
                       -1,  0, -1,  0,  0, 
                        0,  0, -1,  0, -1), nrow = 4L, byrow = TRUE)

calculate_entropy(design)

}
