% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{findEnvOutliers}
\alias{findEnvOutliers}
\title{Find outlying occurrence data in environmental space}
\usage{
findEnvOutliers(
  myPres,
  myEnv = NULL,
  pvalSet = 1e-05,
  checkPairs = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{myPres}{a `SpatialPointsDataFrame`}

\item{myEnv}{a `RasterStack` of env layers. If NULL, it is assumed that `myPres` is a data.frame of the environmental values (columns) at presence locations (rows)}

\item{pvalSet}{numeric; p-value used in Grubb's test for outlier (see package `outliers`)}

\item{checkPairs}{logical. Default to FALSE (TRUE not implemented).}

\item{verbose}{logic. Should messages be printed out?}
}
\value{
Returns a list of SpatialPointsDataFrames with (1) good presence points (2) spatial outliers and (3) environmental outliers.
}
\description{
Environmental outliers
}
\author{
Cory Merow <cory.merow@gmail.com>
}
\keyword{internal}
