% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questionnaire_pages.R
\name{page_first_freetext}
\alias{page_first_freetext}
\title{The first freetext question to show.}
\usage{
page_first_freetext(
  is_interview = FALSE,
  aggregate_score_threshold = 0.535,
  ...
)
}
\arguments{
\item{is_interview}{Should the page show slightly different / additional
instructions and answer options for an interview that is conducted by
another person? Defaults to FALSE.}

\item{aggregate_score_threshold}{The total sum of the scores of the
suggestions has to be higher than this threshold for suggestions to be
shown. The parameter is passed on to \code{\link[=get_job_suggestions]{get_job_suggestions()}}.}

\item{...}{All additional parameters are passed to \code{\link[=new_page]{new_page()}}}
}
\value{
A page object.
}
\description{
Here, the description of the job can be entered in an open freetext field
and suggestions will be generated based on the input.
}
\examples{
my_questionnaire <- list(
  page_first_freetext(),
  page_second_freetext(),
  page_select_suggestion(),
  page_none_selected_freetext(),
  page_followup(1),
  page_followup(2)
)
if (interactive()) {
  app(questionnaire = my_questionnaire)
}
}
\seealso{
\code{\link[=new_page]{new_page()}}
}
