% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\docType{package}
\name{oce}
\alias{oce}
\alias{oce-package}
\title{oce: A package for Oceanographic analysis}
\description{
The oce package provides functions for working with
Oceanographic data, for calculations that are specific
to Oceanography, and for producing graphics that
match the conventions of the field.
}
\section{Specialized functions}{

A key function is \code{\link{read.oce}}, which will attempt
to read Oceanographic data in raw format. This uses
\code{\link{oceMagic}} to try to detect the file type,
based on the file name and contents. If it proves impossible
to detect the type, users should next try a more specialized
function, e.g. \code{\link{read.ctd}} for CTD files, or 
\code{\link{read.ctd.sbe}} for Teledyne-Seabird files.
}

\section{Generic methods}{

A list of the generic methods in oce is provided by
`methods(class="oce")`; a few that are used frequently
are as follows.
\describe{
\item{[[}{Find the value of an item in the object's
    \code{metadata} or \code{data} slot.
    See \link{[[,oce-method} or type \code{?"[[,oce-method"}
    to learn more.}
\item{[[<-}{Alters the named item in the object's \code{metadata} or
    \code{data} slot.
    See \link{[[<-,oce-method} or type \code{?"[[<-,oce-method"}
    to learn more.}
\item{summary}{Displays some information about the object named as an
    argument, including a few elements from its \code{metadata} slot
    and some statistics of the contents of its \code{data} slot.
    See \link{summary,oce-method} or type \code{?"summary,oce-method"}
    to learn more.}
\item{subset}{Takes a subset of an oce object.
    See \link{subset,oce-method} or type \code{?"subset,oce-method"}
    to learn more.}
}
}

\section{Oceanographic data types handled}{

Over a dozen specialized data types are handled by oce,
with generic plots and summaries for each, along with 
the specialized functions needed for typical Oceanographic
analysis.
}

\section{Oce object structure}{

See \code{\link{oce-class}} for a summary of the class structure
and links to documentation for the many subclasses of
oce objects, each aligned with a class of instrument or
or type of dataset.
}

