% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\docType{methods}
\name{subset,argo-method}
\alias{subset,argo-method}
\title{Subset an Argo Object}
\usage{
\S4method{subset}{argo}(x, subset, ...)
}
\arguments{
\item{x}{An object inheriting from \code{\link{argo-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{...}{Ignored.}
}
\value{
An argo object.
}
\description{
Subset an argo object, either by selecting just the "adjusted" data
or by subsetting by pressure or other variables.
}
\details{
If \code{subset} is the string \code{"adjusted"}, then \code{subset} 
replaces the station variables with their adjusted counterparts. In
the argo notation, e.g. \code{PSAL} is replaced with \code{PSAL_ADJUSTED};
in the present notation, this means that \code{salinity} in the \code{data}
slot is replaced with \code{salinityAdjusted}, and the latter is deleted.
Similar replacements are also done with the flags stored in the \code{metadata}
slot.

If \code{subset} is an expression, then the action is somewhat similar
to other \code{subset} functions, but with the restriction that
only one independent variable may be
used in in any call to the function, so that 
repeated calls will be necessary to subset based on more than one
independent variable.  Subsetting may be done by anything
stored in the data, e.g. \code{time},
\code{latitude}, \code{longitude}, \code{profile}, \code{dataMode},
or \code{pressure} or by \code{profile} (a made-up variable)
or \code{id} (from the \code{metadata} slot).
}
\examples{
library(oce)
data(argo)

# Example 1: buset by time, longitude, and pressure
par(mfrow=c(2,2))
plot(argo)
plot(subset(argo, time > mean(time)))
plot(subset(argo, longitude > mean(longitude)))
plot(subset(argoGrid(argo), pressure > 500 & pressure < 1000), which=5)

# Example 2: restrict attention to delayed-mode profiles.
par(mfrow=c(1,1))
plot(subset(argo, dataMode == "D"))

# Example 3: contrast corrected and uncorrected data
par(mfrow=c(1,2))
plotTS(argo)
plotTS(subset(argo, "adjusted"))

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{argo} data: \code{\link{[[,argo-method}},
  \code{\link{[[<-,argo-method}}, \code{\link{argo-class}},
  \code{\link{argoGrid}}, \code{\link{argo}},
  \code{\link{as.argo}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{plot,argo-method}}, \code{\link{read.argo}},
  \code{\link{summary,argo-method}}
}

