% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{binmapAdp}
\alias{binmapAdp}
\title{Bin-map an ADP object}
\usage{
binmapAdp(x, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{An \code{adp} object, i.e. one inheriting from \code{\link{adp-class}}.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}
}
\value{
An object of \code{\link[base]{class}} \code{"adp"}.
}
\description{
Bin-map an ADP object, by interpolating velocities, backscatter amplitudes,
etc., to uniform depth bins, thus compensating for the pitch and roll of the
instrument.  This only makes sense for ADP objects that are in beam
coordinates.
}
\section{Bugs}{
 This only works for 4-beam RDI ADP objects.
}
\examples{

\dontrun{
library(oce)    
beam <- read.oce("/data/archive/sleiwex/2008/moorings/m09/adp/rdi_2615/raw/adp_rdi_2615.000",
                 from=as.POSIXct("2008-06-26", tz="UTC"),
                 to=as.POSIXct("2008-06-26 00:10:00", tz="UTC"),
                 longitude=-69.73433, latitude=47.88126)
beam2 <- binmapAdp(beam)
plot(enuToOther(toEnu(beam), heading=-31.5))
plot(enuToOther(toEnu(beam2), heading=-31.5))
plot(beam, which=5:8) # backscatter amplitude
plot(beam2, which=5:8)
}

}
\author{
Dan Kelley and Clark Richards
}
\references{
The method was devised by Clark Richards for use in his PhD work
at Department of Oceanography at Dalhousie University.
}
\seealso{
See \code{\link{adp-class}} for a discussion of \code{adp} objects
and notes on the many functions dealing with them.

Other things related to \code{adp} data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}}, \code{\link{adp-class}},
  \code{\link{adp}}, \code{\link{as.adp}},
  \code{\link{beamName}}, \code{\link{beamToXyzAdp}},
  \code{\link{beamToXyzAdv}}, \code{\link{beamToXyz}},
  \code{\link{beamUnspreadAdp}},
  \code{\link{enuToOtherAdp}}, \code{\link{enuToOther}},
  \code{\link{plot,adp-method}},
  \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}
}

