% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{gravity}
\alias{gravity}
\title{Acceleration due to earth gravity}
\usage{
gravity(latitude = 45, degrees = TRUE)
}
\arguments{
\item{latitude}{Latitude in \eqn{^\circ}{deg}N or radians north of the
equator.}

\item{degrees}{Flag indicating whether degrees are used for latitude; if set
to \code{FALSE}, radians are used.}
}
\value{
Acceleration due to gravity [\eqn{m^2/s}{m^2/s}].
}
\description{
Compute \eqn{g}{g}, the acceleration due to gravity, as a function of
latitude.
}
\details{
Value not verified yet, except roughly.
}
\examples{
g <- gravity(45) # 9.8
}
\references{
Gill, A.E., 1982. \emph{Atmosphere-ocean Dynamics}, Academic
Press, New York, 662 pp.

\strong{Caution:} Fofonoff and Millard (1983 UNESCO) use a different
formula.
}
\author{
Dan Kelley
}
