% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidem.R
\name{predict.tidem}
\alias{predict.tidem}
\title{Predict a Time Series from a Tidem Tidal Model}
\usage{
\method{predict}{tidem}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{tidem} object, i.e. one inheriting from
\code{\link{tidem-class}}.}

\item{newdata}{optional vector of POSIXt times at which to make the
prediction.  If not present, \code{predict.tidem} uses the times that were
provided in the original call to \code{\link{tidem}}.}

\item{\dots}{optional arguments passed on to children.}
}
\value{
A vector of predictions.
}
\description{
Predict a time series from a tidal model.
This is a wrapper around the predict method for \code{object$model}.
}
\examples{

\dontrun{
library(oce)
# 1. tidal anomaly
data(sealevelTuktoyaktuk)
time <- sealevelTuktoyaktuk[["time"]]
elevation <- sealevelTuktoyaktuk[["elevation"]]
oce.plot.ts(time, elevation, type='l', ylab="Height [m]", ylim=c(-2, 6))
tide <- tidem(sealevelTuktoyaktuk)
lines(time, elevation - predict(tide), col="red")
abline(h=0, col="red")

# 2. prediction at specified times
data(sealevel)
m <- tidem(sealevel)
## Check fit over 2 days (interpolating to finer timescale)
look <- 1:48
time <- sealevel[["time"]]
elevation <- sealevel[["elevation"]]
oce.plot.ts(time[look], elevation[look])
# 360s = 10 minute timescale
t <- seq(from=time[1], to=time[max(look)], by=360)
lines(t, predict(m,newdata=t), col='red')
legend("topright", col=c("black","red"),
legend=c("data","model"),lwd=1)
}

}
\seealso{
Other things related to \code{tidem} data: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{summary,tidem-method}},
  \code{\link{tidedata}}, \code{\link{tidem-class}},
  \code{\link{tidemAstron}}, \code{\link{tidemVuf}},
  \code{\link{tidem}}
}
\author{
Dan Kelley
}
