% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swSpice}
\alias{swSpice}
\title{Seawater spiciness}
\usage{
swSpice(salinity, temperature = NULL, pressure = NULL)
}
\arguments{
\item{salinity}{either salinity [PSU] (in which case \code{temperature} and
\code{pressure} must be provided) \strong{or} a \code{ctd} object (in which
case \code{salinity}, \code{temperature} and \code{pressure} are determined
from the object, and must not be provided in the argument list).}

\item{temperature}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C] on the
ITS-90 scale; see \dQuote{Temperature units} in the documentation for
\code{\link{swRho}}.}

\item{pressure}{seawater pressure [dbar]}
}
\value{
Spice [kg/m\eqn{^3}{^3}].
}
\description{
Compute seawater "spice" (a variable orthogonal to density in TS space).
}
\details{
If the first argument is a \code{ctd} object, then salinity, temperature and
pressure values are extracted from it, and used for the calculation.

Roughly speaking, seawater with a high spiciness is relatively warm and
salty compared with less spicy water. Another interpretation is that spice
is a variable measuring distance orthogonal to isopycnal lines on TS
diagrams (if the diagrams are scaled to make the isopycnals run at 45
degres). The definition used here is that of Pierre Flament. (Other
formulations exist.)  Note that pressure is ignored in the definition.
Spiceness is sometimes denoted \eqn{\pi(S,t,p)}{pi(S,t,p)}.
}
\references{
P. Flament, 2002. A state variable for characterizing water
masses and their diffusive stability: spiciness.  \emph{Progr. Oceanog.},
\bold{54}, 493-501.
}
\seealso{
Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}}, \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swPressure}}, \code{\link{swRho}},
  \code{\link{swRrho}}, \code{\link{swSCTp}},
  \code{\link{swSTrho}}, \code{\link{swSigma0}},
  \code{\link{swSigma1}}, \code{\link{swSigma2}},
  \code{\link{swSigma3}}, \code{\link{swSigma4}},
  \code{\link{swSigmaTheta}}, \code{\link{swSigmaT}},
  \code{\link{swSigma}}, \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swTFreeze}}, \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
