% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapScalebar}
\alias{mapScalebar}
\title{Add a Scalebar to a Map}
\usage{
mapScalebar(x, y = NULL, length, lwd = 1.5 * par("lwd"), cex = par("cex"),
  col = "black")
}
\arguments{
\item{x, y}{position of the scalebar.  Eventually this may be similar to
the corresponding arguments in \code{\link{legend}}, but at the moment
\code{y} must be \code{NULL} and \code{x} must be \code{"topleft"}.}

\item{length}{the distance to indicate, in kilometres.  If not provided, a
reasonable choice is made, based on the underlying map.}

\item{lwd}{line width of the scalebar.}

\item{cex}{character expansion factor for the scalebar text.}

\item{col}{colour of the scalebar.}
}
\description{
Draw a scalebar on an existing map.
}
\details{
The scale is appropriate to the centre of the plot, and will become
increasingly inaccurate away from that spot, with the error depending on
the projection and the fraction of the earth that is shown.
}
\examples{
\dontrun{
library(oce)
data(coastlineWorld)
## Arctic Ocean
par(mar=c(2.5, 2.5, 1, 1))
mapPlot(coastlineWorld, latitudelim=c(60, 120), longitudelim=c(-130,-50),
        col="lightgray", projection="+proj=stere +lat_0=90")
mapScalebar()
}
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapText}},
  \code{\link{mapTissot}}, \code{\link{oceCRS}},
  \code{\link{shiftLongitude}}, \code{\link{usrLonLat}},
  \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
