% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satellite.R
\docType{methods}
\name{plot,satellite-method}
\alias{plot,satellite-method}
\alias{plot.satellite}
\title{Plot a satellite object}
\usage{
\S4method{plot}{satellite}(x, y, asp, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{An object inherting from \code{\link{satellite-class}}.}

\item{y}{String indicating the quantity to be plotted.}

\item{asp}{Optional aspect ratio for plot.}

\item{debug}{A debugging flag, integer.}

\item{...}{extra arguments passed to \code{\link{imagep}}, e.g. set
\code{col} to control colours.}
}
\description{
For an example using \code{g1sst} data, see \code{\link{read.g1sst}}.
}
\seealso{
Other things related to satellite data: \code{\link{g1sst-class}},
  \code{\link{read.g1sst}}, \code{\link{satellite-class}},
  \code{\link{summary,satellite-method}}

Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}
}
\author{
Dan Kelley
}
\concept{
satellite
}
