% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swCSTp}
\alias{swCSTp}
\title{Electrical conductivity ratio from salinity, temperature and pressure}
\usage{
swCSTp(salinity, temperature = 15, pressure = 0, eos = getOption("oceEOS",
  default = "gsw"))
}
\arguments{
\item{salinity}{practical salinity, or a CTD object (in which case its
temperature and pressure are used, and the next two arguments are ignored)}

\item{temperature}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C], defined
on the ITS-90 scale; see the examples, as well as the
\dQuote{Temperature units} section in the documentation for \code{\link{swRho}}.}

\item{pressure}{pressure [dbar]}

\item{eos}{equation of state, either \code{"unesco"} or \code{"gsw"}.}
}
\value{
Conductivity ratio [unitless], i.e. the ratio of conductivity to the
conductivity at salinity=35, temperature=15 (IPTS-68 scale) and pressure=0,
which has numerical value 42.9140 mS/cm = 4.29140 S/m (see
Culkin and Smith, 1980, in the regression result cited at the bottom of
the left-hand column on page 23).
}
\description{
Compute electrical conductivity ratio based on salinity, temperature, and
pressure (relative to the conductivity of seawater with salinity=35,
temperature68=15, and pressure=0).
}
\details{
If \code{eos="unesco"}, the calculation is done by a bisection root search
on the UNESCO formula relating salinity to conductivity, temperature, and
pressure (see \code{\link{swSCTp}}).  If it is \code{"gsw"} then the
Gibbs-SeaWater formulation is used, via \code{\link{gsw_C_from_SP}}.
}
\examples{
expect_equal(1, swCSTp(35, T90fromT68(15), 0, eos="unesco")) # by definition of cond. ratio
expect_equal(1, swCSTp(34.25045, T90fromT68(15), 2000, eos="unesco"), tolerance=1e-7)
expect_equal(1, swCSTp(34.25045, T90fromT68(15), 2000, eos="gsw"), tolerance=1e-7)

}
\references{
1. Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for
computation of fundamental properties of seawater. \emph{Unesco Technical
Papers in Marine Science}, \bold{44}, 53 pp.

2. Culkin, F., and Norman D. Smith, 1980. Determination of the concentration of
potassium chloride solution having the same electrical conductivity, at 15 C
and infinite frequency, as standard seawater of salinity 35.0000 ppt
(Chlorinity 19.37394 ppt). \emph{IEEE Journal of Oceanic Engineering},
\bold{5}, pp 22-23.
}
\seealso{
For thermal (as opposed to electrical) conductivity, see
\code{\link{swThermalConductivity}}. For computation of salinity from
electrical conductivity, see \code{\link{swSCTp}}.

Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swPressure}}, \code{\link{swRho}},
  \code{\link{swRrho}}, \code{\link{swSCTp}},
  \code{\link{swSTrho}}, \code{\link{swSigma0}},
  \code{\link{swSigma1}}, \code{\link{swSigma2}},
  \code{\link{swSigma3}}, \code{\link{swSigma4}},
  \code{\link{swSigmaTheta}}, \code{\link{swSigmaT}},
  \code{\link{swSigma}}, \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTFreeze}},
  \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
