% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceColorsTurbo}
\alias{oceColorsTurbo}
\alias{oce.colorsTurbo}
\title{Create colors similar to the google turbo scheme}
\usage{
oceColorsTurbo(n)
}
\arguments{
\item{n}{number of colors to create.}
}
\description{
This uses the coefficients published (with Apache license) by google,
as described by Mikhailo (2019).
}
\examples{
library(oce)
imagep(volcano, col=oceColorsTurbo(128),
       zlab="oceColorsTurbo")

}
\references{
Mikhailo, Anton.
\dQuote{Turbo, An Improved Rainbow Colormap for Visualization.}
Google AI (blog), August 20, 2019.
\verb{https://ai.googleblog.com/2019/08/turbo-improved-rainbow-colormap-for.html}

The following references provide information on choosing
colour schemes, that are suitable for viewers who have
colour deficiencies.

Light, Adam, and Patrick J. Bartlein. "The End of the Rainbow? Color
Schemes for Improved Data Graphics." \emph{Eos, Transactions American Geophysical
Union} 85, no. 40 (2004): 385.
DOI: 10.1029/2004EO400002

Stephenson, David B. "Comment on 'Color Schemes for Improved Data
Graphics', by A Light and P.J. Bartlein." \emph{Eos, Transactions American
Geophysical Union} 86, no.  20 (2005): 196.
DOI: 10.1029/2005EO200005

Light, Adam, and Patrick J. Bartlein. "Reply to 'Comment on Color
Schemes for Improved Data Graphics,' by A. Light and P.J.  Bartlein'."
\emph{Eos, Transactions American Geophysical Union} 86, no. 20 (2005): 196–196.
DOI: 10.1029/2005EO200006
}
\seealso{
Other things related to colors: 
\code{\link{colormapGMT}()},
\code{\link{colormap}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsGebco}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTwo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}
}
\author{
Dan Kelley
}
\concept{things related to colors}
