% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\docType{methods}
\name{dbConnect,OdbcDriver-method}
\alias{dbConnect,OdbcDriver-method}
\alias{dbConnect}
\title{Connect to a ODBC compatible database}
\usage{
\S4method{dbConnect}{OdbcDriver}(drv, dsn = NULL, ..., timezone = "UTC",
  encoding = "", bigint = c("integer64", "integer", "numeric", "character"),
  driver = NULL, server = NULL, database = NULL, uid = NULL,
  pwd = NULL, .connection_string = NULL)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{dsn}{The Data Source Name.}

\item{...}{Additional ODBC keywords, these will be joined with the other
arguments to form the final connection string.}

\item{timezone}{The Server time zone. Useful if the database has an internal
timezone that is \emph{not} 'UTC'. If the database is in your local timezone set
to \code{Sys.timezone()}. See \code{\link[=OlsonNames]{OlsonNames()}} for a complete list of available
timezones on your system.}

\item{encoding}{The text encoding used on the Database. If the database is
the same as your local encoding set to \code{""}. See \code{\link[=iconvlist]{iconvlist()}} for a
complete list of available encodings on your system. Note strings are always
returned \code{UTF-8} encoded.}

\item{bigint}{The R type that \code{SQL_BIGINT} types should be mapped to,
default is \link[bit64:integer64]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{driver}{The ODBC driver name.}

\item{server}{The server hostname.}

\item{database}{The database on the server.}

\item{uid}{The user identifier.}

\item{pwd}{The password to use.}

\item{.connection_string}{A complete connection string, useful if you are
copy pasting it from another source. If this argument is used any additional
arguments will be appended to this string.}
}
\description{
Connect to a ODBC compatible database
}
\details{
The connection string keywords are driver dependent. The parameters
documented here are common, but some drivers may not accept them. Please see
the specific driver documentation for allowed parameters,
\url{https://www.connectionstrings.com} is also a useful resource of example
connection strings for a variety of databases.
}
